
module Event_Compiler
  
  # CxgGgprW^[
  class Event_Element_Visitor
    
    include Element_Visitor
    include Event_Compiler_Util
    
    # 
    def initialize(map_data,event,page)
      @map_data = map_data
      @event = event
      @page = page
      @event_list = [] # CxgXg(RPG::EventCommand)
      @event_command = nil
    end
    
    # CxgR}h쐬
    def create_event_command(code = 0, indent = 0, parameters = [])
      return RPG::EventCommand.new(code, indent, parameters)
    end
    # CxgR}hǉ
    def add_event_command(code = 0, indent = 0, parameters = [])
      @event_list.push create_event_command(code, indent, parameters)
    end
    # CxgR}h擾
    def get_event_command(code = 0, indent = 0)
      @event_list.reverse_each do |event|
        if event.code == code and event.indent == indent
          return event
        end
      end
      return nil
    end
    
    
    # LN^[hc̎擾
    def get_character_id(value)
      if value == "vC["
        return -1
      elsif value == "̃Cxg"
        return 0
      else
        id,e = @map_data.events.find {|_id,_e| (not _e.nil?) and _e.name == value}
        if e.nil?
          Log.error("Cxg[#{value}]܂B")
          return 0
        end
        return id
      end
      return 0
    end
    
    # g[vhc̎擾
    def get_troop_id(value)
      data_troops = Data_Loader.data_troops
      troop = data_troops.find {|t| (not t.nil?) and t.name == value}
      unless troop.nil?
        return troop.id
      end
      if value =~ /~[0-9]+$/
        return value.to_i
      end
      Log.error("g[v[#{value}]܂B")
      return 1
    end
    
    # Autiof[^쐬
    def create_audio_parameter(value)
      values = value.split(/,|A/)
      audio= RPG::AudioFile.new()
      audio.name = values[0].to_s if values.size >= 1
      audio.volume = values[1].to_i if values.size >= 2
      audio.pitch = values[2].to_i if values.size >= 3
      return audio
    end
    
    # qGg
    def child_accespt(element,i)
      return @event_list if element.child_elements.nil?
      return @event_list if element.child_elements.size - 1 < i
      return element.child_elements[i].accept(self)
    end
    
    # Gg
    def next_accept(element)
      return @event_list if element.next_element.nil?
      return element.next_element.accept(self)
    end
    
    # ftHg
    def visit_default(element)
      if element.name == ''
        add_event_command(0,element.indent,[])
      end
      return next_accept(element)
    end
    
    # 101 
    add_visitor_method("", :visit_message)
    def visit_message(element)
      # ͍쐬Ps
      add_event_command(101,element.indent,[element.value])
      element.related_elements.each do |related_element|
        # ͍쐬Qsڈȍ~
        add_event_command(401,related_element.indent,[related_element.value])
      end
      return next_accept(element)
    end
    
    # 102 I̕\
    add_visitor_method("I̕\", :visit_choices)
    def visit_choices(element)
      choices = element.value.split(/,|A/).collect {|c| c.strip}
      cancel = 0
      parameters = [choices]
      add_event_command(102,element.indent,parameters)
      element.related_elements.zip(element.child_elements) do |related_element,child_element|
        if related_element.nil? or child_element.nil?
          add_event_command(404,element.indent,[])
          break
        end
        if related_element.name =~ /\[(.+)\]̏ꍇ(\*?)/
          select_value = $1.strip
          select_index = choices.index(select_value)
          if $2 == "*"
            cancel = select_index + 1
          end
          add_event_command(402,related_element.indent,[select_index,select_value])
          child_element.accept(self)
        elsif related_element.name =~ /LZ̏ꍇ/
          cancel = 5
          add_event_command(403,related_element.indent,[])
          child_element.accept(self)
        end
      end
      parameters.push cancel
      return next_accept(element)
    end
    
    # 103 l͂̏
    add_visitor_method("l͂̏", :visit_input_number)
    def visit_input_number(element)
      variable_id = 1
      digits_max = 1
      if element.value =~ /\[(.+?)\]/
        variable_id = Variables.index($1.strip)
      end
      if element.value =~ /([0-9])/
        digits_max = [[$1.to_i,1].max,8].min
      end
      add_event_command(103,element.indent,[variable_id,digits_max])
      return next_accept(element)
    end
    
    # 104 ̓IvVύX
    add_visitor_method("̓IvVύX", :visit_message_option)
    def visit_message_option(element)
      parameters = element.parameters
      position = ["","",""].index(parameters[0])
      frame = ["\","\"].index(parameters[1])
      position = 0 if position.nil?
      frame = 0 if frame.nil?
      add_event_command(104,element.indent,[position,frame])
      return next_accept(element)
    end
    
    # 105 {^͂̏
    add_visitor_method("{^͂̏", :visit_input_button)
    def visit_input_button(element)
      parameters = element.parameters
      if parameters.empty?
        # TODO G[
        Log.error("{^͂̏:p[^[Ȃ")
        return next_accept(element)
      end
      variable_name = parameters[0]
      variable_id = Variables.index(variable_name)
      if variable_id.nil?
        # TODO G[
        Log.error("{^͂̏:ϐu#{variable_name}v܂")
        return next_accept(element)
      end
      add_event_command(105,element.indent,[variable_id])
      return next_accept(element)
    end
    
    # 106 EFCg
    add_visitor_method("EFCg", :visit_wait)
    def visit_wait(element)
      parameters = element.parameters
      if parameters.empty?
        # TODO G[
        Log.error("EFCg:p[^[Ȃ")
        return next_accept(element)
      end
      wait = parameters[0].to_i
      add_event_command(106,element.indent,[wait])
      return next_accept(element)
    end
    
    OPERATIONS = ['==','>=','<=','>','<','!=']
    CONDITION_TYPES = [
    [0,'XCb`',proc do |element,parameters|
      id = Event_Compiler_Util.parse_switch_id(element.value)
      val = Event_Compiler_Util.parse_switch_value(element.value[/==.*/])
      parameters.push id
      parameters.push val
    end
    ],
    [1,'ϐ', proc do |element,parameters|
      values = element.value.split(/(==|>=|<=|>|<|!=)/).collect {|v| v.strip}
      id = Event_Compiler_Util.parse_variable_id(values[0])
      ope = OPERATIONS.index(values[1])
      val = 0
      type = 0
      if values[2] =~ /^[0-9]+$/
        val = values[2].to_i
        type = 0
      elsif values[2] =~ /ϐ/
        val = Event_Compiler_Util.parse_variable_id(values[2])
        type = 1
      end
      parameters.push id
      parameters.push type
      parameters.push val
      parameters.push ope
    end
    ],
    [2,'ZtXCb`', proc do |element,parameters|
      values = element.value.split(/==/).collect {|v| v.strip}
      if values.size == 2
        if values[0] =~ /(A|B|C|D)/
          parameters.push $1
        end
        if values[1] == "ON"
          parameters.push 0
        elsif values[1] == "OFF"
          parameters.push 1
        end
      end
    end
    ],
    [3,'^C}[', proc do |element,parameters|
      # ^C}[[0:00]ȏ
      values = element.value.split(/[\[\]:]/).collect {|v| v.strip}
      if values.size == 4
        min = values[1]
        sec = values[2]
        if min =~ /^[0-9]+$/ and sec =~ /^[0-9]+$/
          parameters.push(min.to_i * 60 + sec.to_i)
        else
          parameters.push 0
        end
        if values[3] =~ /ȏ/
          parameters.push 0
        else
          parameters.push 1
        end
      end
    end
    ],
    [4,'AN^[', proc do |element,parameters|
      values = element.value.split(/\s*\s*/,2)
      if values.size == 2
        actor_id = Event_Compiler_Util.parse_actor_id(values[0])
        case values[1]
        when /p[eBɂ/
          type = 0
          value = 1
        when /O\[(.+?)\]ɂȂĂ/
          type = 1
          value = $1
        when /\[(.+?)\]Kς/
          type = 2
          value = Event_Compiler_Util.parse_skill_id($1)
        when /\[(.+?)\]𑕔/
          name = $1
          type = 3
          value = Event_Compiler_Util.parse_weapon_id(name)
        when /h\[(.+?)\]𑕔/
          name = $1
          type = 4
          value = Event_Compiler_Util.parse_armor_id(name)
        when /\[(.+?)\]ɂȂĂ/
          name = $1
          type = 5
          value = Event_Compiler_Util.parse_state_id(name)
        when /\[(.+?)\]ɂȂĂȂ/
          name = $1
          state_id = Event_Compiler_Util.parse_state_id(name)
          # XNvgɕύX
          parameters.clear
          parameters.push 12 # XNvg
          parameters.push "not $game_actors[#{actor_id}].states.include?(#{state_id})"
          return
        else
          Log.error("FAN^[(#{element.value})")
          return
        end
        parameters.push actor_id
        parameters.push type
        parameters.push value
      end
    end
    ],
    [5,'Gl~[', proc do |element,parameters|
    end
    ],
    [6,'LN^[', proc do |element,parameters|
    end
    ],
    [7,'S[h', proc do |element,parameters|
      if element.value =~ /S[h\s*([0-9]+?)\s*(ȏ|ȉ)/
        parameters.push($1.to_i)
        parameters.push($2 == "ȏ" ? 0 : 1)
      end
    end
    ],
    [8,'ACe', proc do |element,parameters|
      if element.value =~ /ACe\[(.+?)\]Ă/
        parameters.push Event_Compiler_Util.parse_item_id($1)
      end
    end
    ],
    [9,'', proc do |element,parameters|
      if element.value =~ /\[(.+?)\]Ă/
        parameters.push Event_Compiler_Util.parse_weapon_id($1)
      end
    end
    ],
    [10,'h', proc do |element,parameters|
      if element.value =~ /h\[(.+?)\]Ă/
        parameters.push Event_Compiler_Util.parse_armor_id($1)
      end
    end
    ],
    [11,'{^', proc do |element,parameters|
      if element.value =~ /{^\s*(.+?)\s*Ă/
        parameters.push Event_Compiler_Util.parse_button_id($1)
      end
    end
    ],
    [12,'XNvg', proc do |element,parameters|
      values = element.value.split(/F/).collect {|s|s.strip}
      if values.size == 2
        parameters.push values[1]
      end
    end
    ],
    ]
    
    # 111 
    add_visitor_method("", :visit_if)
    def visit_if(element)
      condition_type = -1
      condition_proc = nil
      CONDITION_TYPES.each do |ctype,cprefix,cproc|
        if element.value =~ /^#{cprefix}/
          condition_type = ctype
          condition_proc = cproc
          break
        end
      end
      if condition_proc.nil?
        Log.error("F^CvG[#{element.data}")
        return next_accept(element)
      end
      parameters = []
      parameters.push condition_type
      condition_proc.call(element,parameters)
      add_event_command(111,element.indent,parameters)
      element.related_elements.zip(element.child_elements) do |related_element,child_element|
        if related_element.nil? or child_element.nil?
          break
        end
        child_element.accept(self)
        related_element.accept(self)
      end
      return next_accept(element)
    end
    
    # 411 ȊȌꍇ
    add_visitor_method("ȊȌꍇ", :visit_else)
    add_visitor_method("ȊO", :visit_else)
    def visit_else(element)
      add_event_command(411,element.indent,[])
      return next_accept(element)
    end
    
    # 412 I
    add_visitor_method("I", :visit_if_end)
    def visit_if_end(element)
      add_event_command(412,element.indent,[])
      return next_accept(element)
    end
    
    # 112 [v
    add_visitor_method("[v", :visit_loop)
    def visit_loop(element)
      add_event_command(112,element.indent,[])
      element.child_elements.each do |child_element|
        child_element.accept(self)
      end
      element.related_elements.each do |related_element|
        related_element.accept(self)
      end
      return next_accept(element)
    end
    
    # 413 ȏJԂ
    add_visitor_method("ȏJԂ", :visit_loop_end)
    def visit_loop_end(element)
      add_event_command(413,element.indent,[])
      return next_accept(element)
    end
    
    # 113 [v̒f
    add_visitor_method("[v̒f", :visit_loop_break)
    def visit_loop_break(element)
      add_event_command(113,element.indent,[])
      return next_accept(element)
    end
    
    # 115 Cxg̒f
    add_visitor_method("Cxg̒f", :visit_event_break)
    def visit_event_break(element)
      add_event_command(115,element.indent,[])
      return next_accept(element)
    end
    
    # 116 Cxg̈ꎞ
    add_visitor_method("Cxg̈ꎞ", :visit_event_erase)
    def visit_event_erase(element)
      add_event_command(116,element.indent)
      return next_accept(element)
    end
    
    # 117 RCxg
    add_visitor_method("RCxg", :visit_common_event)
    def visit_common_event(element)
      id = parse_common_event_id(element.value)
      add_event_command(117,element.indent,[id])
      return next_accept(element)
    end
    
    # 118 x
    add_visitor_method("x", :visit_label)
    def visit_label(element)
      label = element.value.strip
      add_event_command(118,element.indent,[label])
      return next_accept(element)
    end
    
    # 119 xWv
    add_visitor_method("xWv", :visit_label_jump)
    def visit_label_jump(element)
      label = element.value.strip
      add_event_command(119,element.indent,[label])
      return next_accept(element)
    end
    
    # 121 XCb`̑
    add_visitor_method("XCb`̑", :visit_switches)
    def visit_switches(element)
      values = element.value.gsub(/\[|\]/,'').split(/=/).collect {|v| v.strip}
      if values.size == 2
        switchs = values[0].split(/\.\./).collect {|v| v.strip}
        eid = sid = Event_Compiler_Util.parse_switch_id(switchs[0])
        eid = Event_Compiler_Util.parse_switch_id(switchs[1]) if switchs.size == 2
        flag = Event_Compiler_Util.parse_switch_value(values[1])
        add_event_command(121,element.indent,[sid,eid,flag])
      end
      return next_accept(element)
    end
    
    VARIABLE_OPERATIONS = ['=','+=','-=','*=','/=','%=']
    VARIABLE_OPERATION = /(\=|\+\=|\-\=|\*\=|\/\=|\%\=)/
    VARIABLE_ITEMS = ['萔','ϐ','','ACe','AN^[','Gl~[','LN^[','̑']
    VARIABLE_ITEM = /^(#{VARIABLE_ITEMS.join('|')})\s*\[(.+?)\]/
    VARIABLE_ACTOR_OPERATION = ['x','EXP','HP','SP','MaxHP','MaxSP','r','p','f','','U','h','@h','C']
    VARIABLE_ENEMY_OPERATION = ['HP','SP','MaxHP','MaxSP','r','p','f','','U','h','@h','C']
    VARIABLE_CHARACTER_OPERATION = ['XW','YW','','XW','YW','n`^O']
    VARIABLE_ETC_OPERATION = ['}bvID','p[eBl','S[h','','vC','^C}[','Z[u']
    
    # 122 ϐ̑
    add_visitor_method("ϐ̑", :visit_variables)
    def visit_variables(element)
      if element.value =~ VARIABLE_OPERATION
        operation = $1
        operation_id= VARIABLE_OPERATIONS.index(operation)
        values = element.value.split(/#{Regexp.escape(operation)}/).collect {|v| v.strip}
        if values.size == 2
          variables = values[0].gsub(/\[|\]/,'').split(/\.\./).collect {|v| v.strip}
          eid = sid = Event_Compiler_Util.parse_variable_id(variables[0])
          eid = Event_Compiler_Util.parse_variable_id(variables[1]) if variables.size == 2
          if values[1] =~ /^[0-9]+$/
            # 萔
            variable_item_id = 0
            variable_value_data1 = values[1].to_i
          elsif values[1] =~ VARIABLE_ITEM
            variable_item = $1
            variable_value = $2
            variable_item_id = VARIABLE_ITEMS.index(variable_item)
            variable_value_data1 = 0
            variable_value_data2 = 0
            case variable_item_id
            when 0 # 萔
              variable_value_data1 = variable_value.to_i
            when 1 # ϐ
              variable_value_data1 = Event_Compiler_Util.parse_variable_id(variable_value)
            when 2 # 
              tmp = variable_value.gsub(/\[|\]/,'').split(/\.\./).collect {|v| v.strip.to_i}
              if tmp.size == 2
                variable_value_data1 = tmp[0]
                variable_value_data2 = tmp[1]
              end
            when 3 # ACe
              variable_value_data1 = Event_Compiler_Util.parse_item_id(variable_value)
            when 4 # AN^[
              variable_value_data1 = Event_Compiler_Util.parse_actor_id(variable_value)
              VARIABLE_ACTOR_OPERATION.each_with_index do |name,index|
                if values[1] =~ /\s*#{Regexp.escape(name)}$/
                  variable_value_data2 = index
                  break
                end
              end
            when 5 # Gl~[
              # 퓬pc
              #              variable_value_data1 = Event_Compiler_Util.parse_enemy_id(variable_value)
              #              VARIABLE_ENEMY_OPERATION.each_with_index do |name,index|
              #                if values[1] =~ /\s*#{Regexp.escape(name)}$/
              #                  variable_value_data2 = index
              #                  break
              #                end
              #              end
            when 6 # LN^[
              variable_value_data1 = get_character_id(variable_value)
              tmp = values[1].gsub(/ /,'')
              VARIABLE_CHARACTER_OPERATION.each_with_index do |name,index|
                if tmp =~ /\s*#{Regexp.escape(name)}$/
                  variable_value_data2 = index
                  break
                end
              end
            when 7 # ̑
              tmp = variable_value.gsub(/ /,'')
              VARIABLE_ETC_OPERATION.each_with_index do |name,index|
                if tmp =~ /#{Regexp.escape(name)}/
                  variable_value_data1 = index
                  break
                end
              end
            end
          else
            tmp = values[1].gsub(/ /,'')
            VARIABLE_ETC_OPERATION.each_with_index do |name,index|
              if tmp =~ /#{Regexp.escape(name)}/
                variable_value_data1 = index
                variable_item_id = 7
                break
              end
            end
          end
          add_event_command(122,element.indent,[sid,eid,operation_id,variable_item_id,variable_value_data1,variable_value_data2])
        end
      end
      
      return next_accept(element)
    end
    
    # 123 ZtXCb`̑
    add_visitor_method("ZtXCb`̑", :visit_self_switches)
    def visit_self_switches(element)
      values = element.value. split(/=/).collect {|v| v.strip}
      if values.size == 2
        switch = values[0]
        flag = Event_Compiler_Util.parse_switch_value(values[1])
      end
      add_event_command(123,element.indent,[switch,flag])
      return next_accept(element)
    end
    
    # 124 ^C}[̑
    add_visitor_method("^C}[̑", :visit_timer)
    def visit_timer(element)
      if element.value =~ /n/
        if element.value =~ /([0-9]+):([0-9]+)/
          sec = $1.to_i * 60 + $2.to_i
          add_event_command(124,element.indent,[0,sec])
        end
      elsif element.value =~ /~/
        add_event_command(124,element.indent,[1])
      end
      return next_accept(element)
    end
    
    # 125 S[h̑
    add_visitor_method("S[h̑", :visit_gold)
    def visit_gold(element)
      if element.value =~ /\-/
        operation = 1 # 炷
      else
        operation = 0 # ₷
      end
      # operand_type : Iyh^Cv (0:萔 1:ϐ)
      if element.value =~ /ϐ/
        operand_type = 1
        operand = Event_Compiler_Util.parse_variable_id(element.value)
      else
        operand_type = 0
        if element.value =~ /([0-9]+)/
          operand = $1.to_i
        else
          operand = 0
        end
      end
      add_event_command(125,element.indent,[operation, operand_type, operand])
      return next_accept(element)
    end
    
    # 126 ACȇ
    add_visitor_method("ACȇ", :visit_item)
    def visit_item(element)
      if element.value =~ /\s*\[(.+?)\]\s*(\+|\-)\s*([0-9]+?)\s*/
        name = $1
        op = $2 == "+" ? 0 : 1
        num = $3
        id = Event_Compiler_Util.parse_item_id(name)
        add_event_command(126,element.indent,[id,op,0,num])
      elsif element.value =~ /\s*\[(.+?)\]\s*(\+|\-)\s*ϐ\s*\[(.+?)\]\s*/
        name = $1
        op = $2 == "+" ? 0 : 1
        num = $3
        vid = Event_Compiler_Util.parse_variable_id(num)
        id = Event_Compiler_Util.parse_item_id(name)
        add_event_command(126,element.indent,[id,op,1,vid])
      end
      return next_accept(element)
    end
    
    # 127 ̑
    add_visitor_method("̑", :visit_weapon)
    def visit_weapon(element)
      return next_accept(element)
    end
    
    # 128 h̑
    add_visitor_method("h̑", :visit_armor)
    def visit_armor(element)
      return next_accept(element)
    end
    
    # 129 AN^[̓ւ
    add_visitor_method("AN^[̓ւ", :visit_actor_change)
    def visit_actor_change(element)
      parameters = element.parameters
      unless parameters.empty?
        actor_id = parse_actor_id(parameters[0])
        if parameters[0] =~ //
          operation_type = 0
        else
          operation_type = 1
        end
        if parameters.size == 2 and parameters[1] =~ //
          initialize_actor = 1
        else
          initialize_actor = 0
        end
        add_event_command(129,element.indent,[actor_id,operation_type,initialize_actor])
      end
      return next_accept(element)
    end
    
    # 131 EBhEXL̕ύX
    add_visitor_method("EBhEXL̕ύX", :visit_windowskin_change)
    def visit_windowskin_change(element)
      return next_accept(element)
    end
    
    # 132 og BGM ̕ύX
    add_visitor_method("og BGM ̕ύX", :visit_battle_bgm_change)
    add_visitor_method("ogBGM̕ύX", :visit_battle_bgm_change)
    def visit_battle_bgm_change(element)
      audio = create_audio_parameter(element.value)
      add_event_command(132,element.indent,[audio])
      return next_accept(element)
    end
    
    # 133 ogI ME ̕ύX
    add_visitor_method("ogI ME ̕ύX", :visit_battle_me_change)
    def visit_battle_me_change(element)
      return next_accept(element)
    end
    
    # 134 Z[u֎~̕ύX
    add_visitor_method("Z[u֎~̕ύX", :visit_save_disable)
    def visit_save_disable(element)
      if element.value =~ //
        add_event_command(134,element.indent,[1])
      else
        add_event_command(134,element.indent,[0])
      end
      return next_accept(element)
    end
    
    # 135 j[֎~̕ύX
    add_visitor_method("j[֎~̕ύX", :visit_menu_disable)
    def visit_menu_disable(element)
      if element.value =~ //
        add_event_command(135,element.indent,[1])
      else
        add_event_command(135,element.indent,[0])
      end
      return next_accept(element)
    end
    
    # 136 GJEg֎~̕ύX
    add_visitor_method("GJEg֎~̕ύX", :visit_encount_disable)
    def visit_encount_disable(element)
      return next_accept(element)
    end
    
    # 201 ꏊړ
    # ꏊړFeXg,(1,1)
    # ꏊړF[eXg],(1,1)
    # ꏊړF[eXg],(1,1),
    # ꏊړF[eXg],(1,1),,tF[hȂ
    # ꏊړFϐ[}bvhc][wW][xW],,tF[hȂ
    add_visitor_method("ꏊړ", :visit_move_to)
    def visit_move_to(element)
      type = 0
      map_id = 1
      new_x = 0
      new_y = 0
      new_direction = 0
      transition = 0
      if element.value =~ /^ϐ\[/
        # ϐw
        type = 1
        args = element.value.split(/,|A/).collect {|v|v.strip}
        if args[0] =~ /\[(.+?)\]\[(.+?)\]\[(.+?)\]/
          # XXX
          map_id = Event_Compiler_Util.parse_variable_id($1)
          new_x = Event_Compiler_Util.parse_variable_id($2)
          new_y = Event_Compiler_Util.parse_variable_id($3)
        end
        if args.size >= 2
          new_direction = Event_Compiler_Util.parse_direction(args[1])
        end
        if args.size >= 3
          transition = 1
        end
      else
        # ڎw
        type = 0
        args = element.value.split(/,|A/).collect {|v|v.strip}
        map_id = Event_Compiler_Util.parse_map_id(args[0])
        if args.size >= 3
          new_x = args[1].gsub(/\(|\)/,'').to_i
          new_y = args[2].gsub(/\(|\)/,'').to_i
        end
        if args.size >= 4
          new_direction = Event_Compiler_Util.parse_direction(args[1])
        end
        if args.size >= 5
          transition = 1
        end
      end
      add_event_command(201,element.indent,[type,map_id,new_x,new_y,new_direction,transition])
      return next_accept(element)
    end
    
    # 202 Cxg̈ʒuݒ
    add_visitor_method("Cxg̈ʒuݒ", :visit_event_position)
    def visit_event_position(element)
      parameters = []
      values = element.value.split(/,|A/).collect {|v|v.strip}
      parameters[0] = get_character_id(values[0])
      if values[1] =~ /^\(/
        # ڎw
        parameters[1] = 0
        # TODO `FbN
        parameters[2] = values[1][/[0-9]+/].to_i
        parameters[3] = values[2][/[0-9]+/].to_i
        parameters[4] = parse_direction(values[3])
      elsif values[1] =~ /^ϐ\[(.+?)\]\[(.+?)\]/
        # ϐw
        parameters[1] = 1
        parameters[2] = parse_variable_id($1.strip)
        parameters[3] = parse_variable_id($2.strip)
        parameters[4] = parse_direction(values[2])
      elsif values[1] =~ /^\[(.+?)\]ƌ/
        # Cxgƌ
        parameters[1] = 2
        parameters[2] = get_character_id($1)
        parameters[3] = 0
        parameters[4] = parse_direction(values[2])
      end
      add_event_command(202,element.indent,parameters)
      if Log.debug?
        Log.debug(parameters.collect {|p| p.to_s}.join(","))
      end
      return next_accept(element)
    end
    
    # 203 }bṽXN[
    add_visitor_method("}bṽXN[", :visit_map_scroll)
    def visit_map_scroll(element)
      values = element.parameters
      if values.size == 3
        direction = Event_Compiler_Util.parse_direction(values[0])
        distance = values[1].to_i
        speed = values[2].to_i
        add_event_command(203,element.indent,[direction, distance, speed])
      end
      return next_accept(element)
    end
    
    # 204 }bv̐ݒύX
    add_visitor_method("}bv̐ݒύX", :visit_map_config)
    def visit_map_config(element)
      return next_accept(element)
    end
    
    # 205 tHO̐FύX
    add_visitor_method("tHO̐FύX", :visit_fog_tone)
    def visit_fog_tone(element)
      return next_accept(element)
    end
    
    # 206 tHO̕sxύX
    add_visitor_method("tHO̕sxύX", :visit_fog_opacity)
    def visit_fog_opacity(element)
      return next_accept(element)
    end
    
    # 207 Aj[V̕\
    add_visitor_method("Aj[V̕\", :visit_animation)
    def visit_animation(element)
      values = element.parameters
      if values.size == 2
        character_id = get_character_id(values[0])
        animation_id = Event_Compiler_Util.parse_animation_id(values[1])
        add_event_command(207,element.indent,[character_id,animation_id])
      end
      return next_accept(element)
    end
    
    # 208 Ԃ̕ύX
    add_visitor_method("Ԃ̕ύX", :visit_transparent)
    def visit_transparent(element)
      return next_accept(element)
    end
    
    # 209 ړ[g̐ݒ
    add_visitor_method("ړ[g̐ݒ", :visit_move_route)
    def visit_move_route(element)
      parameters = element.value.split(/,|A|i|j/)
      # ړLN^[
      character = 0
      case parameters[0]
      when "vC["
        character = -1
      when "̃Cxg"
        character = 0
      else # Cxgw
        character = get_character_id(parameters[0])
      end
      
      # ړ[g쐬
      move_route = RPG::MoveRoute.new
      
      if parameters.include?("JԂ")
        move_route.repeat = true # JԂ
      else
        move_route.repeat = false # JԂȂ
      end
      if parameters.include?("ړłȂꍇ͖")
        move_route.skippable = true # ړłȂꍇ͖
      else
        move_route.skippable = false # ړłȂꍇ͖Ȃ
      end
      
      add_event_command(209,element.indent,[character,move_route])
      
      # ړ[g
      move_route.list = []
      
      element.related_elements.each do |related_element|
        # GgC
         (name,value) = related_element.value.split(/F|:/,2)
        related_element.name = name unless name.nil?
        related_element.value = value unless value.nil?
        # ANZvg
        move_command = related_element.accept(self)
        move_route.list.push move_command
        add_event_command(509,related_element.indent,[move_command])
      end
      
      # Ip
      move_route.list.push RPG::MoveCommand.new
      
      return next_accept(element)
    end
    
    # ړ[g
    [
    [1,'Ɉړ'],
    [2,'Ɉړ'],
    [3,'EɈړ'],
    [4,'Ɉړ'],
    [5,'Ɉړ'],
    [6,'EɈړ'],
    [7,'Ɉړ'],
    [8,'EɈړ'],
    [9,'_Ɉړ'],
    [10,'vC[ɋ߂Â'],
    [11,'vC[牓'],
    [12,'Oi'],
    [13,''],
    [14,'Wv',:Integer,:Integer],
    [15,'EFCg',:Integer],
    [16,''],
    [17,''],
    [18,'E'],
    [19,''],
    [20,'E90x]'],
    [21,'90x]'],
    [22,'180x]'],
    [23,'E90x]'],
    [24,'_ɕ]'],
    [25,'vC[̕'],
    [26,'vC[̋t'],
    [27,'XCb`ON',proc do |command,values|
      unless values.empty?
        command.parameters.push Event_Compiler_Util.parse_switch_id(values[0])
      end
    end
    ],
    [28,'XCb`OFF',proc do |command,values|
      unless values.empty?
        command.parameters.push Event_Compiler_Util.parse_switch_id(values[0])
      end
    end
    ],
    [29,'ړx̕ύX',:Integer],
    [30,'ړpx̕ύX',:Integer],
    [31,'ړAjON'],
    [32,'ړAjOFF'],
    [33,'~AjON'],
    [34,'~AjOFF'],
    [35,'ŒON'],
    [36,'ŒOFF'],
    [37,'蔲ON'],
    [38,'蔲OFF'],
    [39,'őOʂɕ\ON'],
    [40,'őOʂɕ\OFF'],
    [41,'OtBbNύX',proc do |command,values|
      unless values.empty?
        name = ""
        hue = 0
        direction = 2
        pattern = 0
        name = values[0].to_s if values.size >= 1
        hue = values[1].to_i if values.size >= 2
        if values.size >= 3
          direction = Event_Compiler_Util.parse_direction(values[2])
        end
        pattern = values[3].to_i if values.size >= 4
        command.parameters = [name, hue, direction, pattern]
      end
    end
    ],
    [42,'sx̕ύX',:Integer],
    [43,'@̕ύX',proc do |command,values|
      unless values.empty?
        blend_type = Event_Compiler_Util.parse_blend_type(values[0])
        command.parameters.push blend_type
      end
    end
    ],
    [44,'SẺt', proc do |command,values|
      unless values.empty?
        se = RPG::AudioFile.new()
        se.name = values[0].to_s if values.size >= 1
        se.volume = values[1].to_i if values.size >= 2
        se.pitch = values[2].to_i if values.size >= 3
        command.parameters.push se
      end
    end
    ],
    [44,'SE', proc do |command,values|
      unless values.empty?
        se = RPG::AudioFile.new()
        se.name = values[0].to_s if values.size >= 1
        se.volume = values[1].to_i if values.size >= 2
        se.pitch = values[2].to_i if values.size >= 3
        command.parameters.push se
      end
    end
    ],
    [45,'XNvg', :String],
    ].each do |id,value,*param_types|
      method_name = "visit_move_route__#{id}".to_sym
      # \bhǉ
      add_visitor_method(value, method_name)
      # \bh쐬
      define_method(method_name) do |element|
        # [g쐬
        command = RPG::MoveCommand.new(id)
        # [gp[^[\bh`쐬
        element_values = element.value.split(/A|,/)
        param_types.zip(element_values) do |_type,_value|
          case _type
          when :Integer
            command.parameters.push _value.to_i
          when :String
            command.parameters.push _value.to_s
          when Proc,Method
            _type.call(command,element_values)
          end
        end
        return command
      end
    end
    
    # 210 ړ܂ŃEFCg
    add_visitor_method("ړ܂ŃEFCg", :visit_move_wait)
    def visit_move_wait(element)
      add_event_command(210,element.indent,[])
      return next_accept(element)
    end
    
    # 221 gWV
    add_visitor_method("gWV", :visit_transition_setup)
    def visit_transition_setup(element)
      add_event_command(221,element.indent,[])
      return next_accept(element)
    end
    
    # 222 gWVs
    add_visitor_method("gWVs", :visit_transition_exec)
    def visit_transition_exec(element)
      add_event_command(222,element.indent,[element.value.strip])
      return next_accept(element)
    end
    
    # 223 ʂ̐FύX
    add_visitor_method("ʂ̐FύX", :visit_screen_tone)
    def visit_screen_tone(element)
      p = element.value.delete("()").split(/,|A/).collect {|s| s.to_i}
      if p.size == 5
        tone = Tone.new(p[0],p[1],p[2],p[3])
        time = p[4]
        add_event_command(223,element.indent,[tone,time])
      end
      return next_accept(element)
    end
    
    # 224 ʂ̃tbV
    add_visitor_method("ʂ̃tbV", :visit_screen_flash)
    def visit_screen_flash(element)
      p = element.value.delete("()").split(/,|A/).collect {|s| s.to_i}
      if p.size == 5
        c = Color.new(p[0],p[1],p[2],p[3])
        t = p[4]
        add_event_command(224,element.indent,[c,t])
      end
      return next_accept(element)
    end
    
    # 225 ʂ̃VFCN
    add_visitor_method("ʂ̃VFCN", :visit_screen_shake)
    def visit_screen_shake(element)
      parameters = element.parameters
      if parameters.size == 3
        add_event_command(225,element.indent,parameters.collect {|n|n.to_i})
      end
      return next_accept(element)
    end
    
    # 231 sN`̕\
    add_visitor_method("sN`̕\", :visit_picture)
    def visit_picture(element)
      return next_accept(element)
    end
    
    # 232 sN`̈ړ
    add_visitor_method("sN`̈ړ", :visit_picture_move)
    def visit_picture_move(element)
      return next_accept(element)
    end
    
    # 233 sN`̉]
    add_visitor_method("sN`̉]", :visit_picture_angle)
    def visit_picture_angle(element)
      return next_accept(element)
    end
    
    # 234 sN`̐FύX
    add_visitor_method("sN`̐FύX", :visit_picture_tone)
    def visit_picture_tone(element)
      return next_accept(element)
    end
    
    # 235 sN`̏
    add_visitor_method("sN`̏", :visit_picture_erase)
    def visit_picture_erase(element)
      return next_accept(element)
    end
    
    # 236 V̐ݒ
    add_visitor_method("V̐ݒ", :visit_weather)
    def visit_weather(element)
      return next_accept(element)
    end
    
    # 241 BGM ̉t
    add_visitor_method("BGM ̉t", :visit_bgm)
    add_visitor_method("BGM̉t", :visit_bgm)
    def visit_bgm(element)
      audio = create_audio_parameter(element.value)
      add_event_command(241,element.indent,[audio])
      return next_accept(element)
    end
    
    # 242 BGM ̃tF[hAEg
    add_visitor_method("BGM ̃tF[hAEg", :visit_bgm_fadeout)
    add_visitor_method("BGM̃tF[hAEg", :visit_bgm_fadeout)
    def visit_bgm_fadeout(element)
      time = 1
      if element.value =~ /([0-9]+?)/
        time = $1.to_i
      end
      add_event_command(242,element.indent,[time])
      return next_accept(element)
    end
    
    # 245 BGS ̉t
    add_visitor_method("BGS ̉t", :visit_bgs)
    def visit_bgs(element)
      return next_accept(element)
    end
    
    # 246 BGS ̃tF[hAEg
    add_visitor_method("BGS ̃tF[hAEg", :visit_bgs_fadeout)
    def visit_bgs_fadeout(element)
      return next_accept(element)
    end
    
    # 247 BGM / BGS ̋L
    add_visitor_method("BGM / BGS ̋L", :visit_bgm_bgs_save)
    def visit_bgm_bgs_save(element)
      return next_accept(element)
    end
    
    # 248 BGM / BGS ̕A
    add_visitor_method("BGM / BGS ̕A", :visit_bgm_bgs_load)
    def visit_bgm_bgs_load(element)
      return next_accept(element)
    end
    
    # 249 ME ̉t
    add_visitor_method("ME ̉t", :visit_me)
    def visit_me(element)
      return next_accept(element)
    end
    
    # 250 SE ̉t
    add_visitor_method("SE ̉t", :visit_se)
    add_visitor_method("SẺt", :visit_se)
    add_visitor_method("SE", :visit_se)
    def visit_se(element)
      values = element.parameters
      unless values.empty?
        se = RPG::AudioFile.new()
        se.name = values[0].to_s if values.size >= 1
        se.volume = values[1].to_i if values.size >= 2
        se.pitch = values[2].to_i if values.size >= 3
        add_event_command(250,element.indent,[se])
      end
      return next_accept(element)
    end
    
    # 251 SE ̒~
    add_visitor_method("SE ̒~", :visit_se_stop)
    def visit_se_stop(element)
      return next_accept(element)
    end
    
    # 301 og̏
    add_visitor_method("og̏", :visit_battle)
    def visit_battle(element)
      values = element.value.split(/,|A/)
      unless values.empty?
        troop_id = get_troop_id(values[0])
        add_event_command(301,element.indent,[troop_id,false,false])
        element.related_elements.zip(element.child_elements) do |related_element,child_element|
          if related_element.nil? or child_element.nil?
            add_event_command(604,element.indent,[])
            break
          end
          related_element.accept(self)
          child_element.accept(self)
        end
      end
      return next_accept(element)
    end
    
    # 601 ꍇ
    add_visitor_method("ꍇ", :visit_battle_win)
    def visit_battle_win(element)
      add_event_command(601,element.indent)
      return next_accept(element)
    end
    
    # 602 ꍇ
    add_visitor_method("ꍇ", :visit_battle_escape)
    def visit_battle_escape(element)
      get_event_command(301,element.indent).parameters[1] = true
      add_event_command(602,element.indent)
      return next_accept(element)
    end
    
    # 603 ꍇ
    add_visitor_method("ꍇ", :visit_battle_lose)
    def visit_battle_lose(element)
      get_event_command(301,element.indent).parameters[2] = true
      add_event_command(603,element.indent)
      return next_accept(element)
    end
    
    # 302 Vbv̏
    add_visitor_method("Vbv̏", :visit_shop)
    def visit_shop(element)
      return next_accept(element)
    end
    
    # 303 O͂̏
    add_visitor_method("O͂̏", :visit_input_name)
    def visit_input_name(element)
      return next_accept(element)
    end
    
    # 311 HP ̑
    add_visitor_method("HP ̑", :visit_increase_or_decrease_hp)
    def visit_increase_or_decrease_hp(element)
      return next_accept(element)
    end
    
    # 312 SP ̑
    add_visitor_method("SP ̑", :visit_increase_or_decrease_sp)
    def visit_increase_or_decrease_sp(element)
      return next_accept(element)
    end
    
    # 313 Xe[g̕ύX
    add_visitor_method("Xe[g̕ύX", :visit_state_change)
    def visit_state_change(element)
      return next_accept(element)
    end
    
    # 314 S
    add_visitor_method("S", :visit_recover_all)
    def visit_recover_all(element)
      return next_accept(element)
    end
    
    # 315 EXP ̑
    add_visitor_method("EXP ̑", :visit_increase_or_decrease_exp)
    def visit_increase_or_decrease_exp(element)
      return next_accept(element)
    end
    
    # 316 x̑
    add_visitor_method("x̑", :visit_increase_or_decrease_lebel)
    def visit_increase_or_decrease_lebel(element)
      return next_accept(element)
    end
    
    # 317 p[^̑
    add_visitor_method("p[^̑", :visit_increase_or_decrease_parameters)
    def visit_increase_or_decrease_parameters(element)
      return next_accept(element)
    end
    
    # 318 XL̑
    add_visitor_method("XL̑", :visit_increase_or_decrease_skill)
    def visit_increase_or_decrease_skill(element)
      return next_accept(element)
    end
    
    # 319 ̕ύX
    add_visitor_method("̕ύX", :visit_equip_change)
    def visit_equip_change(element)
      return next_accept(element)
    end
    
    # 320 AN^[̖OύX
    add_visitor_method("AN^[̖OύX", :visit_actor_name_change)
    def visit_actor_name_change(element)
      return next_accept(element)
    end
    
    # 321 AN^[̃NXύX
    add_visitor_method("AN^[̃NXύX", :visit_actor_class_change)
    def visit_actor_class_change(element)
      return next_accept(element)
    end
    
    # 322 AN^[̃OtBbNύX
    add_visitor_method("AN^[̃OtBbNύX", :visit_actor_graphics_change)
    def visit_actor_graphics_change(element)
      return next_accept(element)
    end
    
    # 331 Gl~[ HP 
    add_visitor_method("Gl~[ HP ", :visit_enemy_increase_or_decrease_hp)
    def visit_enemy_increase_or_decrease_hp(element)
      return next_accept(element)
    end
    
    # 332 Gl~[ SP 
    add_visitor_method("Gl~[ SP ", :visit_enemy_increase_or_decrease_sp)
    def visit_enemy_increase_or_decrease_sp(element)
      return next_accept(element)
    end
    
    # 333 Gl~[̃Xe[gύX
    add_visitor_method("Gl~[̃Xe[gύX", :visit_enemy_state_change)
    def visit_enemy_state_change(element)
      return next_accept(element)
    end
    
    # 334 Gl~[̏o
    add_visitor_method("Gl~[̏o", :visit_enemy_appear)
    def visit_enemy_appear(element)
      return next_accept(element)
    end
    
    # 335 Gl~[̕ϐg
    add_visitor_method("Gl~[̕ϐg", :visit_enemy_metamorphosis)
    def visit_enemy_metamorphosis(element)
      return next_accept(element)
    end
    
    # 336 Gl~[̑S
    add_visitor_method("Gl~[̑S", :visit_enemy_recover_all)
    def visit_enemy_recover_all(element)
      return next_accept(element)
    end
    
    # 337 퓬Aj[V̕\
    add_visitor_method("퓬Aj[V̕\", :visit_battle_animation)
    def visit_battle_animation(element)
      return next_accept(element)
    end
    
    # 338 _[W̏
    add_visitor_method("_[W̏", :visit_battle_damage)
    def visit_battle_damage(element)
      return next_accept(element)
    end
    
    # 339 ANV̋
    add_visitor_method("ANV̋", :visit_battle_action)
    def visit_battle_action(element)
      return next_accept(element)
    end
    
    # 340 og̒f
    add_visitor_method("og̒f", :visit_battle_break)
    def visit_battle_break(element)
      return next_accept(element)
    end
    
    # 351 j[ʂ̌Ăяo
    add_visitor_method("j[ʂ̌Ăяo", :visit_call_menu)
    def visit_call_menu(element)
      return next_accept(element)
    end
    
    # 352 Z[uʂ̌Ăяo
    add_visitor_method("Z[uʂ̌Ăяo", :visit_call_save)
    def visit_call_save(element)
      return next_accept(element)
    end
    
    # 353 Q[I[o[
    add_visitor_method("Q[I[o[", :visit_call_gameover)
    def visit_call_gameover(element)
      add_event_command(353,element.indent)
      return next_accept(element)
    end
    
    # 354 ^Cgʂɖ߂
    add_visitor_method("^Cgʂɖ߂", :visit_call_title)
    def visit_call_title(element)
      return next_accept(element)
    end
    
    # 355 XNvg
    add_visitor_method("XNvg", :visit_script)
    def visit_script(element)
      add_event_command(355,element.indent,[element.value])
      element.related_elements.each do |related_element|
        add_event_command(655,element.indent,[related_element.value])
      end
      return next_accept(element)
    end
    
    #-------------------------
    # IWiCxgR}h
    #-------------------------
    def add_script_event_command(element,value)
      value.split(/\n/).each_with_index do |script,index|
        if index == 0
          add_event_command(355,element.indent,[script])
        else
          add_event_command(655,element.indent,[script])
        end
      end
      add_event_command(655,element.indent,["true"])
    end
    
    add_visitor_method("Cxg̃g[ύX", :visit_event_tone_change)
    add_visitor_method("Cxg̐FύX", :visit_event_tone_change)
    def visit_event_tone_change(element)
      parameters = element.parameters
      if parameters.empty?
        Log.error("p[^[܂B")
        return next_accept(element)
      end
      event_id = get_character_id(parameters[0])
      tone = []
      case parameters.size
      when 4
        tone[0] = parameters[1] # r
        tone[1] = parameters[2] # g
        tone[2] = parameters[3] # b
      when 5
        tone[0] = parameters[1] # r
        tone[1] = parameters[2] # g
        tone[2] = parameters[3] # b
        tone[3] = parameters[4] # b
      else
        Log.error("p[^[܂B")
        return next_accept(element)
      end
      script = <<_SCRIPT_
get_character(#{event_id}).tone = Tone.new(#{tone.join(',')})
_SCRIPT_
      add_script_event_command(element,script)
      return next_accept(element)
    end
    
    add_visitor_method("Cxg̃r[|[gO", :visit_event_viewport_remove)
    def visit_event_viewport_remove(element)
      parameters = element.parameters
      if parameters.empty?
        Log.error("Cxg̃r[|[gOFp[^[܂B")
        return next_accept(element)
      end
      event_id_list = []
      parameters.each do |param|
        if param =~ /^[0-9]+$/
          event_id_list.push param.to_i
        elsif param == "vC["
          event_id_list.push 0
        elsif param == "̃Cxg"
          event_id_list.push @event.id
        else
          id = get_character_id(param)
          event_id_list.push id if id != 0
        end
      end
      script = <<_SCRIPT_
e = [#{event_id_list.join(',')}]
$scene.change_character_viewport(e)
_SCRIPT_
      add_script_event_command(element,script)
      return next_accept(element)
    end
    
    add_visitor_method("Cxg̃r[|[gA", :visit_event_viewport_return)
    def visit_event_viewport_return(element)
      parameters = element.parameters
      if parameters.empty?
        Log.error("Cxg̃r[|[gA:p[^[܂B")
        return next_accept(element)
      end
      event_id_list = []
      parameters.each do |param|
        if param =~ /^[0-9]+$/
          event_id_list.push param.to_i
        elsif param == "vC["
          event_id_list.push 0
        elsif param == "̃Cxg"
          event_id_list.push @event.id
        else
          id = get_character_id(param)
          event_id_list.push id if id != 0
        end
      end
      script = <<_SCRIPT_
e = [#{event_id_list.join(',')}]
$scene.reset_character_viewport(e)
_SCRIPT_
      add_script_event_command(element,script)
      return next_accept(element)
    end
    
    add_visitor_method("p[eB̕тۑ", :visit_save_party_order)
    def visit_save_party_order(element)
      add_script_event_command(element,"Event_Script.save_party_order")
      return next_accept(element)
    end
    
    add_visitor_method("p[eB̕т𕜋A", :visit_load_party_order)
    def visit_load_party_order(element)
      add_script_event_command(element,"Event_Script.load_party_order")
      return next_accept(element)
    end
    
    add_visitor_method("p[eB̕тύX", :visit_change_party_order)
    def visit_change_party_order(element)
      parameters = element.parameters
      script = <<_SCRIPT_
l = [#{parameters.join(',')}]
Event_Script.change_party_order(l)
_SCRIPT_
      add_script_event_command(element,script)
      return next_accept(element)
    end
    
  end
end

# RpC
Event_Compiler.compile
